﻿//////////////////////////////////////////////
// JpgCompressionParams.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::jpg
{
	struct JpgCompressionParams final
	{
		// Quantization parameters
		nkMemory::BufferView<const unsigned char> _lumQuant ;
		nkMemory::BufferView<const unsigned char> _chrQuant ;

		// Huffman parameters
		nkMemory::BufferView<const unsigned char> _lumDcHuffmanCounts ;
		nkMemory::BufferView<const unsigned char> _lumAcHuffmanCounts ;
		nkMemory::BufferView<const unsigned char> _chrDcHuffmanCounts ;
		nkMemory::BufferView<const unsigned char> _chrAcHuffmanCounts ;

		nkMemory::BufferView<const unsigned char> _lumDcHuffmanTable ;
		nkMemory::BufferView<const unsigned char> _lumAcHuffmanTable ;
		nkMemory::BufferView<const unsigned char> _chrDcHuffmanTable ;
		nkMemory::BufferView<const unsigned char> _chrAcHuffmanTable ;
	} ;
}